<?php

namespace App\Http\Controllers\Crm\Users;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Mail;
use Swift_SmtpTransport;

class UsersController extends Controller
{
    public function index(Request $request)
    {
        if ($request->session()->get('id') != null) {
            $agents = [];
            if(session()->get('usertype') == 1){
                $departments = DB::table('departments')->get();
                $usertypes = DB::table('usertype')->get();
                $users = DB::table('users')
                    ->select('users.*','usertype.name as usertype_name')
                    ->leftjoin('usertype','usertype.id','users.usertype_id')
                    ->where('users.usertype_id',2)
                    ->orwhere('users.usertype_id',3)
                    ->orwhere('users.usertype_id',1)
                    ->orwhere('users.usertype_id',4)
                    ->get();
                if(!empty($users)){
                    foreach ($users as $row) {
                        $depart = DB::table('department_assign')
                                    ->select('department_assign.department_id','department_assign.user_id','departments.id as depart_id','departments.name as department_name')
                                    ->leftjoin('departments','departments.id','department_assign.department_id')
                                    ->where('department_assign.user_id',$row->id)
                                    ->first();
                        $sub_department = DB::table('sub_department_assign')
                                        ->select('sub_department_assign.sub_department_id', 'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                        ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                        ->where('sub_department_assign.user_id', $row->id)
                                        ->get();
                        if(!empty($depart) && !empty($sub_department)){
                            $data = [
                                'user_id' => $row->id,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'email' => $row->email,
                                'cnic' => $row->cnic,
                                'gender' => $row->gender,
                                'phone' => $row->phone_number,
                                'address' => $row->address,
                                'image' => $row->image,
                                'department' => $depart->department_name,
                                'department_id' => $depart->depart_id,
                                'sub_department' => $sub_department,
                                'usertype' => $row->usertype_name,
                                'usertype_id' => $row->usertype_id,
                                'is_deleted' => $row->is_deleted,
                            ];
                        }
                        else{
                            $data = [
                                'user_id' => $row->id,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'email' => $row->email,
                                'cnic' => $row->cnic,
                                'gender' => $row->gender,
                                'phone' => $row->phone_number,
                                'address' => $row->address,
                                'image' => $row->image,
                                'department' => "-",
                                'department_id' => "-",
                                'sub_department' => "-",
                                'usertype' => $row->usertype_name,
                                'usertype_id' => $row->usertype_id,
                                'is_deleted' => $row->is_deleted,
                            ];
                        }
                        
                        array_push($agents, $data);
                    }
                }
            
                return view('pages.agents',compact('agents','departments','usertypes'));
            }
            elseif(session()->get('usertype') == 3){
                $departments = DB::table('departments')->get();
                $usertypes = DB::table('usertype')->get();
                $users = DB::table('users')
                    ->select('users.*','usertype.name as usertype_name')
                    ->leftjoin('usertype','usertype.id','users.usertype_id')
                    ->where('users.parent_user_id',session()->get('id'))
                    ->get();
                if(!empty($users)){
                    foreach ($users as $row) {
                        $depart = DB::table('department_assign')
                                    ->select('department_assign.department_id','department_assign.user_id','departments.id as depart_id','departments.name as department_name')
                                    ->leftjoin('departments','departments.id','department_assign.department_id')
                                    ->where('department_assign.user_id',$row->id)
                                    ->first();
                        $sub_department = DB::table('sub_department_assign')
                                        ->select('sub_department_assign.sub_department_id', 'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                        ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                        ->where('sub_department_assign.user_id', $row->id)
                                        ->get();           
                        if(!empty($depart) && !empty($sub_department)){
                            $data = [
                                'user_id' => $row->id,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'email' => $row->email,
                                'cnic' => $row->cnic,
                                'gender' => $row->gender,
                                'phone' => $row->phone_number,
                                'address' => $row->address,
                                'image' => $row->image,
                                'department' => $depart->department_name,
                                'department_id' => $depart->depart_id,
                                'sub_department' => $sub_department,
                                'usertype' => $row->usertype_name,
                                'usertype_id' => $row->usertype_id,
                                'is_deleted' => $row->is_deleted,
                            ];
                        }
                        else{
                            $data = [
                                'user_id' => $row->id,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'email' => $row->email,
                                'cnic' => $row->cnic,
                                'gender' => $row->gender,
                                'phone' => $row->phone_number,
                                'address' => $row->address,
                                'image' => $row->image,
                                'department' => "-",
                                'department_id' => "-",
                                'sub_department' => "-",
                                'usertype' => $row->usertype_name,
                                'usertype_id' => $row->usertype_id,
                                'is_deleted' => $row->is_deleted,
                            ];
                        }
                        
                        array_push($agents, $data);
                    }
                }
                return view('pages.agents',compact('agents','usertypes','departments'));
            }
            elseif(session()->get('usertype') == 2){
                $departments = DB::table('departments')->get();
                $usertypes = DB::table('usertype')->get();
                $users = DB::table('users')
                    ->select('users.*','usertype.name as usertype_name')
                    ->leftjoin('usertype','usertype.id','users.usertype_id')
                    ->where('users.parent_user_id',session()->get('id'))
                    ->get();
                if(!empty($users)){
                    foreach ($users as $row) {
                        $depart = DB::table('department_assign')
                                    ->select('department_assign.department_id','department_assign.user_id','departments.id as depart_id','departments.name as department_name')
                                    ->leftjoin('departments','departments.id','department_assign.department_id')
                                    ->where('department_assign.user_id',$row->id)
                                    ->first();
                        $sub_department = DB::table('sub_department_assign')
                                        ->select('sub_department_assign.sub_department_id', 'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                        ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                        ->where('sub_department_assign.user_id', $row->id)
                                        ->get();
                        if(!empty($depart)  && !empty($sub_department)){
                            $data = [
                                'user_id' => $row->id,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'email' => $row->email,
                                'cnic' => $row->cnic,
                                'gender' => $row->gender,
                                'phone' => $row->phone_number,
                                'address' => $row->address,
                                'image' => $row->image,
                                'department' => $depart->department_name,
                                'department_id' => $depart->depart_id,
                                'sub_department' => $sub_department,
                                'usertype' => $row->usertype_name,
                                'usertype_id' => $row->usertype_id,
                                'is_deleted' => $row->is_deleted,
                            ];
                        }
                        else{
                            $data = [
                                'user_id' => $row->id,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'email' => $row->email,
                                'cnic' => $row->cnic,
                                'gender' => $row->gender,
                                'phone' => $row->phone_number,
                                'address' => $row->address,
                                'image' => $row->image,
                                'department' => "-",
                                'department_id' => "-",
                                'sub_department' => "-",
                                'usertype' => $row->usertype_name,
                                'usertype_id' => $row->usertype_id,
                                'is_deleted' => $row->is_deleted,
                            ];
                        }
                        
                        array_push($agents, $data);
                    }
                }
                return view('pages.agents',compact('agents','usertypes','departments'));
            }

        } else {

            return redirect()->route('login');
        }
    }

    //add agents
    public function addagent(Request $request){
        // dd($request);
        
        $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
        $pass = array(); //remember to declare $pass as an array
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
        for ($i = 0; $i < 8; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        if(session()->get('usertype') == 1){
            $validate = $request->validate([
                'first_name' => 'required',
                'email' => 'required',
                'phone' => 'required',
                // 'cnic' => 'required',
                'gender' => 'required',
                // 'address' => 'required',
                'department' => 'required',
                'usertype' => 'required',
            ]);
        }
        else{
            $validate = $request->validate([
                'first_name' => 'required',
                'email' => 'required',
                'phone' => 'required',
                // 'cnic' => 'required',
                'gender' => 'required',
                // 'address' => 'required',
            ]);
        }
        
        $image = "";
        if($request->gender == "Male"){
            $image = "male.png";
        }
        else{
            $image = "female.png";
        }
        if(session()->get('usertype') == 1){
            if($request->usertype == 2){
                $agent = [
                    'first_name' => $request->first_name,
                    'last_name' => $request->last_name,
                    'email' => $request->email,
                    'password' => sha1(implode($pass)),
                    'phone_number' => $request->phone,
                    'cnic' => $request->cnic,
                    'gender' => $request->gender,
                    'address' => $request->address,
                    'image' => $image,
                    'status' => 1,
                    'parent_user_id' => $request->add_hod,
                    'usertype_id' => $request->usertype,
                ];
            }elseif ($request->usertype == 4) {
                $agent = [
                    'first_name' => $request->first_name,
                    'last_name' => $request->last_name,
                    'email' => $request->email,
                    'password' => sha1(implode($pass)),
                    'phone_number' => $request->phone,
                    'cnic' => $request->cnic,
                    'gender' => $request->gender,
                    'address' => $request->address,
                    'image' => $image,
                    'status' => 1,
                    'parent_user_id' => $request->add_hod_managers,
                    'usertype_id' => $request->usertype,
                ];
            }
            else{
                $agent = [
                    'first_name' => $request->first_name,
                    'last_name' => $request->last_name,
                    'email' => $request->email,
                    'password' => sha1(implode($pass)),
                    'phone_number' => $request->phone,
                    'cnic' => $request->cnic,
                    'gender' => $request->gender,
                    'address' => $request->address,
                    'image' => $image,
                    'status' => 1,
                    'parent_user_id' => session()->get('id'),
                    'usertype_id' => $request->usertype,
                ];
            }
            
        }
        elseif(session()->get('usertype') == 3){
            if($request->usertype == 2){
                $agent = [
                    'first_name' => $request->first_name,
                    'last_name' => $request->last_name,
                    'email' => $request->email,
                    'password' => sha1(implode($pass)),
                    'phone_number' => $request->phone,
                    'cnic' => $request->cnic,
                    'gender' => $request->gender,
                    'address' => $request->address,
                    'image' => $image,
                    'status' => 1,
                    'parent_user_id' => session()->get('id'),
                    'usertype_id' => $request->usertype,
                ];
            }elseif($request->usertype == 4){
                $agent = [
                    'first_name' => $request->first_name,
                    'last_name' => $request->last_name,
                    'email' => $request->email,
                    'password' => sha1(implode($pass)),
                    'phone_number' => $request->phone,
                    'cnic' => $request->cnic,
                    'gender' => $request->gender,
                    'address' => $request->address,
                    'image' => $image,
                    'status' => 1,
                    'parent_user_id' => $request->add_hod,
                    'usertype_id' => $request->usertype,
                ];
            }   
        }
        elseif(session()->get('usertype') == 2){
            $agent = [
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'password' => sha1(implode($pass)),
                'phone_number' => $request->phone,
                'cnic' => $request->cnic,
                'gender' => $request->gender,
                'address' => $request->address,
                'image' => $image,
                'status' => 1,
                'parent_user_id' => session()->get('id'),
                'usertype_id' => 4,
            ];  
        }
        
        // dd($agent);
        $check_user = DB::table('users')->where('email', $request->email)->first();
        if(empty($check_user)){
            $insert_agent = DB::table('users')->insertGetId($agent);

            if($insert_agent){

                // if(!empty($request->department))
                // {
                    if(session()->get('usertype') == 1){ // Admin

                        $insert_assign_depart = DB::table('department_assign')
                                                ->insert(['department_id' => $request->department,'user_id' => $insert_agent]);
                        if($insert_assign_depart){
                            $department = DB::table('departments')->where('id',$request->department)->first();
                            $usertype = DB::table('usertype')->where('id',$request->usertype)->first();

                            if($request->usertype == 3){ // HOD
                                if(isset($request->add_sub_department)){
                                    if(count($request->add_sub_department) > 0){ // Assign HOD Sub Department
                                        foreach ($request->add_sub_department as $row) {
                                            $sub_depart = [
                                                'sub_department_id' => $row,
                                                'user_id' => $insert_agent,
                                            ];
                                            DB::table('sub_department_assign')->insert($sub_depart);
                                        }
                                    }
                                }
                                toastr()->success('HOD Add Successfully');
                            }elseif( $request->usertype == 2){ // Manager
                                if(!empty($request->add_hod_sub_department)){
                                    $sub_depart = [
                                        'sub_department_id' => $request->add_hod_sub_department,
                                        'user_id' => $insert_agent,
                                    ];
                                    $insert_sub_department = DB::table('sub_department_assign')->insert($sub_depart);
                                    if($insert_sub_department){
                                       toastr()->success('Manager Add Successfully'); 
                                    }
                                    else{
                                        toastr()->error('Something went wrong while Sub Department');
                                    }
                                }
                            }elseif($request->usertype == 4){ // Agent 
                                toastr()->success('Agent Add Successfully'); 
                            }

                            /* Swift Mailer For HOD */
                            $transport = new \Swift_SmtpTransport('staffshaw.com', 465, 'ssl');
                            $transport->setUsername("info@staffshaw.com");
                            $transport->setPassword("Info100");
                            $gmail = new \Swift_Mailer($transport);

                            $message = "<p>Hi ". $request->first_name .",</p>
                            <p>You have been invited to join the CRM system of StaffShaw Pvt Ltd.</p><p>To access the system go to https://crm.staffshaw.com/ and use the below credentials.</p><p>Email: ".$request->email." <br/>Password: ". implode($pass) ."</p><br><p>Best Regards, <br/>Team StaffShaw</p>";
                            $message = (new \Swift_Message("Account Opening"))
                                                    ->setFrom("info@staffshaw.com","Staffshaw")
                                                    ->setTo($request->email)
                                                    ->setBody($message)
                                                    ->setContentType('text/html');
                            $send_email = $gmail->send($message);
                            return redirect()->route('agents');
                            
                        }
                        else{
                            toastr()->error('Something went wrong while adding Department');
                            return redirect()->route('agents');
                        }
                    }
                    elseif(session()->get('usertype') == 3){ // HOD
                        $insert_assign_depart = DB::table('department_assign')
                                                ->insert(['department_id' => session()->get('department_id'),'user_id' => $insert_agent]);

                        if($insert_assign_depart){
                            $department = DB::table('departments')->where('id',session()->get('department_id'))->first();
                            $usertype = DB::table('usertype')->where('id',2)->first();
                            if($request->usertype == 2){ // Sub Department assign to Manager
                                if(isset($request->add_sub_department)){
                                    try{
                                        $sub_depart = [
                                            'sub_department_id' => $request->add_sub_department,
                                            'user_id' => $insert_agent,
                                        ];
                                        $add_sub = DB::table('sub_department_assign')->insert($sub_depart);
                                        if($add_sub){
                                            toastr()->success('Manager Add Successfully');
                                        }else{
                                            toastr()->error('Something went wrong while Manager Add Sub Department');
                                        }
                                    }catch(Throwable $e){
                                        dd($e->getMessage());
                                    }
                                }
                                else{
                                    toastr()->success('Manager Add Successfully');
                                }
                            }
                            else{ // Sub Department assign to Agent/Developer
                                
                                try{
                                    $get_manager_sub_department_id = DB::table('sub_department_assign')->where('user_id', $request->add_hod)->first();
                                    if($get_manager_sub_department_id){
                                        $sub_depart = [
                                            'sub_department_id' => $get_manager_sub_department_id->sub_department_id,
                                            'user_id' => $insert_agent,
                                        ];
                                        $add_sub = DB::table('sub_department_assign')->insert($sub_depart);
                                        if($add_sub){
                                            toastr()->success('Agent Add Successfully');
                                        }else{
                                            toastr()->error('Something went wrong while Agent Add Sub Department');
                                        }
                                    }else{
                                        toastr()->warning("Agent add successfully but sub department not assign");
                                    }
                                    
                                }catch(Throwable $e){
                                    dd($e->getMessage());  
                                }
                            }

                            

                            $transport = new \Swift_SmtpTransport('staffshaw.com', 465, 'ssl');
                            $transport->setUsername("info@staffshaw.com");
                            $transport->setPassword("Info100");
                            $gmail = new \Swift_Mailer($transport);
                            $message = "<p>Hi ". $request->first_name .",</p>
                            <p>You have been invited to join the CRM system of StaffShaw Pvt Ltd.</p><p>To access the system go to https://crm.staffshaw.com/ and use the below credentials.</p><p>Email: ".$request->email." <br/>Password: ". implode($pass) ."</p><br><p>Best Regards, <br/>Team StaffShaw</p>";
                            $message = (new \Swift_Message("Account Opening"))
                                                    ->setFrom("info@staffshaw.com","Staffshaw")
                                                    ->setTo($request->email)
                                                    ->setBody($message)
                                                    ->setContentType('text/html');
                            $send_email = $gmail->send($message);
                            return redirect()->route('agents');
                        }
                        else{
                            toastr()->error('Something went wrong while adding Department');
                            return redirect()->route('agents');
                        }
                    }
                    elseif(session()->get('usertype') == 2){ // Manager
                        $insert_assign_depart = DB::table('department_assign')
                                                ->insert(['department_id' => session()->get('department_id'),'user_id' => $insert_agent]);

                        if($insert_assign_depart){
                            $insert_assign_sub_department = DB::table('sub_department_assign')
                                                        ->insert(['sub_department_assign.sub_department_id' => session()->get('sub_department_id'), 'user_id' => $insert_agent ]);
                                                        
                            $department = DB::table('departments')->where('id',session()->get('department_id'))->first();
                            $usertype = DB::table('usertype')->where('id',2)->first();
                            
                            // try{
                            //     $sub_depart = [
                            //         'sub_department_id' => $request->add_sub_department,
                            //         'user_id' => $insert_agent,
                            //     ];
                            //     $add_sub = DB::table('sub_department_assign')->insert($sub_depart);
                            //     if($add_sub){
                            //         toastr()->success('Manager Add Successfully');
                            //     }else{
                            //         toastr()->error('Something went wrong while Manager Add Sub Department');
                            //     }
                            // }catch(Throwable $e){
                            //     dd($e->getMessage());
                            // }

                            

                            $transport = new \Swift_SmtpTransport('staffshaw.com', 465, 'ssl');
                            $transport->setUsername("info@staffshaw.com");
                            $transport->setPassword("Info100");
                            $gmail = new \Swift_Mailer($transport);
                            $message = "<p>Hi ". $request->first_name .",</p>
                            <p>You have been invited to join the CRM system of StaffShaw Pvt Ltd.</p><p>To access the system go to https://crm.staffshaw.com/ and use the below credentials.</p><p>Email: ".$request->email." <br/>Password: ". implode($pass) ."</p><br><p>Best Regards, <br/>Team StaffShaw</p>";
                            $message = (new \Swift_Message("Account Opening"))
                                                    ->setFrom("info@staffshaw.com","Staffshaw")
                                                    ->setTo($request->email)
                                                    ->setBody($message)
                                                    ->setContentType('text/html');
                            $send_email = $gmail->send($message);
                            toastr()->success('Agent Add Successfully');
                            return redirect()->route('agents');
                        }
                        else{
                            toastr()->error('Something went wrong while adding Department');
                            return redirect()->route('agents');
                        }
                    }

                // }
                // else{
                //     toastr()->success('Agent Add Successfully');
                //     return redirect()->route('agents');
                // }
                toastr()->success('Agent Add Successfully');
                return redirect()->route('agents');
            }
            else{
                toastr()->error('Something went wrong');
                return redirect()->route('agents');
            }
        }else{
            toastr()->error('This email already exist');
            return redirect()->route('agents');
        }
    }

    //update agents
    public function updateagent(Request $request){

        if(session()->get('usertype') == 1){
            $validate = $request->validate([
                'first_name' => 'required',
                // 'last_name' => 'required',
                'email' => 'required',
                'phone' => 'required',
                'cnic' => 'required',
                'gender' => 'required',
                'address' => 'required',
                'department' => 'required',
                'usertype' => 'required',
            ]);

            $agent = [
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'phone_number' => $request->phone,
                'cnic' => $request->cnic,
                'gender' => $request->gender,
                'address' => $request->address,
                'status' => 1,
                'is_deleted' => $request->account_status,
                'usertype_id' => $request->usertype,
            ];
        }
        elseif(session()->get('usertype') == 3){
            $validate = $request->validate([
                'first_name' => 'required',
                // 'last_name' => 'required',
                'email' => 'required',
                'phone' => 'required',
                'cnic' => 'required',
                'gender' => 'required',
                'address' => 'required',
            ]);

            $agent = [
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'phone_number' => $request->phone,
                'cnic' => $request->cnic,
                'gender' => $request->gender,
                'address' => $request->address,
            ];
        }


        $update_agent = DB::table('users')->where('id', $request->leadid)->update($agent);

        if($update_agent == false){
            if(!empty($request->department))
            {
                $update_assign_depart = DB::table('department_assign')
                                            ->where('user_id', $request->leadid)
                                            ->update(['department_id' => $request->department]);
                if($update_assign_depart){
                    toastr()->success('Agent Update Successfully');
                    return redirect()->route('agents');
                }
                else{
                    $insert_assign_depart = DB::table('department_assign')
                                            ->insert(['department_id' => $request->department,'user_id' => $request->leadid]);
                    if($insert_assign_depart){
                        toastr()->success('Agent Update Successfully');
                        return redirect()->route('agents');
                    }
                    else{
                        toastr()->error('Something went wrong while updating Department');
                        return redirect()->route('agents');
                    }
                }
            }
            else{
                toastr()->success('Agent Update Successfully');
                return redirect()->route('agents');
            }
            
        }
        else{
            toastr()->success('Agent Update Successfully');
                return redirect()->route('agents');
        }
    }

    //soft delete agent
    public function deleteagent(Request $request){

        if(session()->get('id') != null){
            $status = [
                "is_deleted" => '1',
            ];

            $check_agent = DB::table('users')->where('id', $request->deleteagentid)->update($status);
            if($check_agent){
                toastr()->success('Agent Deactivated Successfully');
                return redirect()->route('agents');
            }
            else{
                toastr()->error('Something went wrong while deleting');
                return redirect()->route('agents');
            }
        }
        else{
            return redirect()->route('login');
        }
    }
    //Activate agent
    public function activateAgent($id){
        
        if(session()->get('id') != null){
            $status = [
                "is_deleted" => '0',
            ];

            $check_agent = DB::table('users')->where('id', $id)->update($status);
            if($check_agent){
                toastr()->success('User Activate Successfully');
                return redirect()->route('agents');
            }
            else{
                toastr()->error('Something went wrong while Activation');
                return redirect()->route('agents');
            }
        }
        else{
            return redirect()->route('login');
        }
    }
    
    
      //hard delete agent
    public function harddeleteagent($id){

            $check_agent = DB::table('users')->where('id', $id)->delete();;

            if($check_agent){
                toastr()->success('User Deleted Successfully');
                return redirect()->route('agents');
            }
            else{
                toastr()->error('Something went wrong while deleting');
                return redirect()->route('agents');
            }
       
    }

    
}
